<?php
/*--------------------------------------------------------------
   Number.php 2021-08-25
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\App\Data\Factory;

use Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data\Number as NumberData;
use Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data\Number\Value as NumberValue;

class Number
{
    /**
     * Return number data.
     */
    public function createNumberData(NumberValue $number): NumberData
    {
        return NumberData::create($number);
    }
    
    
    /**
     * Return value.
     */
    public function createValue(float $value): NumberValue
    {
        return NumberValue::create($value);
    }
}